Imports System.Collections

'
' Instances of this class are composite objects that contain
' DocumentElementIF objects.
'
Public MustInherit Class CompositeDocumentElement
    Inherits AbstractDocumentElement
    ' Collection of this object's children
    Private children As New ArrayList()

    ' The cached value from the previous call to getCharLength
    ' or -1 to indicate that charLength does not contain a
    ' cached value.
    Private cachedCharLength As Integer = -1

    '
    ' the child object of this object that is at the given position.
    '
    ' index - The index of the child
    Public Function GetChild(ByVal index As Integer) As IDocumentElement
        Return CType(children(index), IDocumentElement)
    End Function 'GetChild

    ' Make the given DocumentElementIF a child of this object
    Public Sub Add(ByVal child As IDocumentElement)
        SyncLock GetType(CompositeDocumentElement)
            SyncLock child
                children.Add(child)
                CType(child, AbstractDocumentElement).Parent = Me
                changeNotification()
            End SyncLock
        End SyncLock
    End Sub 'Add

    ' Make the given DocumentElementIF NOT a child of this object
    Public Sub Remove(ByVal child As AbstractDocumentElement)
        SyncLock GetType(CompositeDocumentElement)
            SyncLock child
                If Me Is child.Parent Then
                    child.Parent = Nothing
                End If
                children.Remove(child)
                changeNotification()
            End SyncLock
        End SyncLock
    End Sub 'Remove

    ' the number of children this object has
    Public ReadOnly Property Count() As Integer
        Get
            Return children.Count
        End Get
    End Property

    '
    ' A call to this method means that one of this object's
    ' children has changed in a way that invalidates whatever
    ' data this object may be caching about its children.
    '
    Public Sub changeNotification()
        cachedCharLength = -1
        If Parent IsNot Nothing Then
            Parent.changeNotification()
        End If
    End Sub 'changeNotification 

    ' the number of characters that this object contains
    Public Overrides ReadOnly Property CharLength() As Integer
        Get
            Dim len As Integer = 0
            For i As Integer = 0 To children.Count - 1
                Dim thisChild As AbstractDocumentElement
                thisChild = CType(children(i), AbstractDocumentElement)
                len += thisChild.CharLength
            Next i
            cachedCharLength = len
            Return len
        End Get
    End Property
End Class 'CompositeDocumentElement
